package fr.asip.cps3.exemple.vues.ecrans.resultats;

import java.awt.Color;
import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de rsultats avec Informations et 3 codes retour
 */
public class SortieResultatTripleInfo extends SortieResultatDoubleInfo {

	/**
	 * Libell du champ de la troisime opration
	 */
	protected JLabel libelleOperation3;
	
	/**
	 * Texte du champ de la troisime opration
	 */
	protected JTextField texteOperation3;
	
	/**
	 * Libell du champ du troisime code retour
	 */
	protected JLabel libelleCodeRetour3;
	
	/**
	 * Texte du champ du troisime code retour
	 */
	protected JTextField texteCodeRetour3;
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de rsultat
	 */
	public SortieResultatTripleInfo(FenetrePrincipale fenetre) {

		super(fenetre);
		
		libelleOperation3 = new JLabel("Operation 3 : ");
		libelleCodeRetour3 = new JLabel("Retour 3 : ");

    	texteOperation3 = new JTextField();
    	texteCodeRetour3 = new JTextField();
    	texteOperation3.setEditable(false);
    	texteCodeRetour3.setEditable(false);
    	texteOperation3.setBackground(Color.white);
    	texteCodeRetour3.setBackground(Color.white);
    	
	}
	
	/*
	 * (non-Javadoc)
	 * @see fr.asip.cps3.exemple.vues.ecrans.IEcran#affiche()
	 */
	public void affiche() {
    	
    	JFrame fenetre = this.fenetre.getFenetre();

    	if(fenetre != null && fenetre.getContentPane() != null) {    	
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	
	    	// Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        if(texteInfos != null)
	        	texteInfos.setText("");
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleOperation, EcranUtil.styleLibelleSortie, 0, 0, 1, 1);
	        g.ajoute(texteOperation, EcranUtil.styleTexteSortie, 0, 1, 1, 4);
	        // Ligne 1
	        g.ajoute(libelleRetour, EcranUtil.styleLibelleSortie, 1, 0, 1, 1);
	        g.ajoute(texteRetour, EcranUtil.styleTexteSortie, 1, 1, 1, 4);
	        // Ligne 2
	        g.ajoute(libelleOperation2, EcranUtil.styleLibelleSortie, 2, 0, 1, 1);
	        g.ajoute(texteOperation2, EcranUtil.styleTexteSortie, 2, 1, 1, 4);
	        // Ligne 3
	        g.ajoute(libelleCodeRetour2, EcranUtil.styleLibelleSortie, 3, 0, 1, 1);
	        g.ajoute(texteCodeRetour2, EcranUtil.styleTexteSortie, 3, 1, 1, 4);
	        // Ligne 4
	        g.ajoute(libelleOperation3, EcranUtil.styleLibelleSortie, 4, 0, 1, 1);
	        g.ajoute(texteOperation3, EcranUtil.styleTexteSortie, 4, 1, 1, 4);
	        // Ligne 5
	        g.ajoute(libelleCodeRetour3, EcranUtil.styleLibelleSortie, 5, 0, 1, 1);
	        g.ajoute(texteCodeRetour3, EcranUtil.styleTexteSortie, 5, 1, 1, 4);
	        // Ligne 6
	        g.ajoute(libelleInfos, EcranUtil.styleLibelleLigneEntiere, 6, 0, 1, 5);
	        // Ligne 7
	        g.ajoute(scrollInfos, EcranUtil.styleScrollInfos, 7, 0, 1, 5);
	        // Ligne 8
	        if(barreStatut != null)
	        	barreStatut.setText(this.fenetre.getBarreStatut().getText());
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 8, 0, 1, 6);
	        
    	}

    }

	/**
     * Affecte le texte de la troisime opration
     * @param operation Le texte de la troisime opration
     */
	public void setOperation3(String operation3) {
		if(texteOperation3 != null)
			texteOperation3.setText(operation3);
	}

	/**
	 * Affecte le texte du troisime code retour
	 * @param codeRetour Le texte du troisime code retour
	 */
	public void setCodeRetour3(String codeRetour3) {
		if(texteCodeRetour3 != null)
			texteCodeRetour3.setText(codeRetour3);		
	}
}
